package com.biz.crm.sfa.admin.web.report.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.dto.VisitCompletionProgressDetailDto;
import com.biz.crm.sfa.admin.web.report.dto.VisitCompletionProgressPageDto;
import com.biz.crm.sfa.admin.web.report.enums.VisitStatisticalType;
import com.biz.crm.sfa.admin.web.report.repository.VisitCompletionProgressVoRepository;
import com.biz.crm.sfa.admin.web.report.service.VisitCompletionProgressVoService;
import com.biz.crm.sfa.admin.web.report.vo.VisitCompletionProgressDetailVo;
import com.biz.crm.sfa.admin.web.report.vo.VisitCompletionProgressVo;
import com.biz.crm.sfa.business.help.defense.sdk.enums.HelpStatusEnum;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 拜访完成进度service
 * @author: rentao
 * @date: 2022/7/6 14:33
 */
@Service
@Slf4j
public class VisitCompletionProgressVoServiceImpl implements VisitCompletionProgressVoService {

  @Autowired private VisitCompletionProgressVoRepository visitCompletionProgressVoRepository;


  /**
   * 拜访完成进度报表 日
   *
   * @param pageable
   * @param dto
   * @author rentao
   * @date a
  */
  @Override
  public Page<VisitCompletionProgressVo> findByConditions(Pageable pageable, VisitCompletionProgressPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new VisitCompletionProgressPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<VisitCompletionProgressVo> recordMonthVoPage = this.visitCompletionProgressVoRepository.findByConditions(pageable, dto);
    this.assembleData(recordMonthVoPage.getRecords(), dto,VisitStatisticalType.DAY);
    return recordMonthVoPage;
  }

  @Override
  public Page<VisitCompletionProgressVo> findMonthByConditions(Pageable pageable,
      VisitCompletionProgressPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new VisitCompletionProgressPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<VisitCompletionProgressVo> recordMonthVoPage = this.visitCompletionProgressVoRepository.findMonthByConditions(pageable, dto);
    this.assembleData(recordMonthVoPage.getRecords(), dto,VisitStatisticalType.MONTH);
    return recordMonthVoPage;
  }

  @Override
  public List<VisitCompletionProgressDetailVo> findTrackByConditions(VisitCompletionProgressDetailDto visitCompletionProgressDetailDto) {
    //拜访id查询 拿到客户 终端信息 查询客户终端 经纬度




    //协防id查询


    //查询客户经纬度 拜访信息
    return null;
  }

  private void assembleData(List<VisitCompletionProgressVo> list, VisitCompletionProgressPageDto dto,VisitStatisticalType visitStatisticalType){
    if(CollectionUtils.isEmpty(list)){return;}
    NumberFormat percent = NumberFormat.getPercentInstance();
    percent.setMaximumFractionDigits(2);
    List<VisitCompletionProgressVo> completionProgressVos = this.visitCompletionProgressVoRepository.findListByConditions(dto);
    if(CollectionUtils.isEmpty(completionProgressVos)){return;}
    //这个是拜访/协防分组
    Map<String, List<VisitCompletionProgressVo>> listMap = completionProgressVos.stream().collect(Collectors.groupingBy(VisitCompletionProgressVo::getVisitType));
    for (VisitCompletionProgressVo record : list) {
      List<VisitCompletionProgressVo> completionProgressVoList = listMap.get(VisitTypeEnum.VISIT.getDictCode());
      //realName,userName,postName,postCode,orgCode,orgName,visitDate
      if(!CollectionUtils.isEmpty(completionProgressVoList)){
        List<VisitCompletionProgressVo> completionProgressVolists = this.assemble(record,completionProgressVoList,visitStatisticalType);
        if(!CollectionUtils.isEmpty(completionProgressVolists)){
          Map<String, Long> attendanceRecordCountMap = completionProgressVolists.stream().collect(Collectors.groupingBy(VisitCompletionProgressVo::getVisitStatus, Collectors.counting()));
          Long visitNoComplet = attendanceRecordCountMap.get(VisitStatusEnum.NOT_VISIT.getDictCode()) == null ?0L:attendanceRecordCountMap.get(VisitStatusEnum.NOT_VISIT.getDictCode());
          Long visitComplet = attendanceRecordCountMap.get(VisitStatusEnum.VISIT_TO_COMPLETE.getDictCode()) == null ?0L:attendanceRecordCountMap.get(VisitStatusEnum.VISIT_TO_COMPLETE.getDictCode());
          Long visitException = attendanceRecordCountMap.get(VisitStatusEnum.EXCEPTION.getDictCode()) == null ?0L:attendanceRecordCountMap.get(VisitStatusEnum.EXCEPTION.getDictCode());
          Long visitUnder = attendanceRecordCountMap.get(VisitStatusEnum.IN_THE_VISIT.getDictCode()) == null ?0L:attendanceRecordCountMap.get(VisitStatusEnum.IN_THE_VISIT.getDictCode());
          record.setVisitComplet(visitComplet);
          record.setVisitNoComplet(visitNoComplet);
          record.setVisitException(visitException);
          record.setVisitUnder(visitUnder);
          BigDecimal visitPercent = BigDecimal.valueOf(visitComplet)
              .divide(BigDecimal.valueOf(record.getVisitCount()),2,BigDecimal.ROUND_HALF_UP).setScale(2, RoundingMode.HALF_UP);
          record.setVisitPercentum(percent.format(visitPercent.doubleValue()));
        }
      }
      //协防
      List<VisitCompletionProgressVo> helpCompletionProgressVos = listMap.get(VisitTypeEnum.HELP_DEFENSE.getDictCode().toLowerCase());
      if(!CollectionUtils.isEmpty(helpCompletionProgressVos)){
        List<VisitCompletionProgressVo> completionProgressVolists = this.assemble(record,helpCompletionProgressVos,visitStatisticalType);
        if(!CollectionUtils.isEmpty(completionProgressVolists)){
          Map<String, Long> helpAttendanceRecordCountMap =
              completionProgressVolists.stream().collect(Collectors.groupingBy(VisitCompletionProgressVo::getVisitStatus, Collectors.counting()));
          Long helpNoComplet = helpAttendanceRecordCountMap.get(HelpStatusEnum.NO.getDictCode()) == null ? 0L : helpAttendanceRecordCountMap.get(HelpStatusEnum.NO.getDictCode());
          Long helpComplet = helpAttendanceRecordCountMap.get(HelpStatusEnum.COMPLETE.getDictCode()) == null ? 0L : helpAttendanceRecordCountMap.get(HelpStatusEnum.COMPLETE.getDictCode());
          Long helpException = helpAttendanceRecordCountMap.get(HelpStatusEnum.EXCEPTION.getDictCode()) == null ? 0L : helpAttendanceRecordCountMap.get(HelpStatusEnum.EXCEPTION.getDictCode());
          Long helpUnder = helpAttendanceRecordCountMap.get(HelpStatusEnum.IN.getDictCode()) == null ? 0L : helpAttendanceRecordCountMap.get(HelpStatusEnum.IN.getDictCode());
          record.setHelpComplet(helpComplet);
          record.setHelpNoComplet(helpNoComplet);
          record.setHelpException(helpException);
          record.setHelpUnder(helpUnder);
          BigDecimal helpPercent = BigDecimal.valueOf(helpComplet)
              .divide(BigDecimal.valueOf(record.getHelpCount()),2,BigDecimal.ROUND_HALF_UP).setScale(2, RoundingMode.HALF_UP);
          record.setHelpPercentum(percent.format(helpPercent.doubleValue()));
        }
      }
    }
  }


  private List<VisitCompletionProgressVo> assemble(VisitCompletionProgressVo record,List<VisitCompletionProgressVo> completionProgressVos,VisitStatisticalType visitStatisticalType){
    if(VisitStatisticalType.DAY.getDictCode().equals(visitStatisticalType.getDictCode())){
      return completionProgressVos.stream().filter(
          visitCompletionProgressVo ->
              ObjectUtils.defaultIfNull(visitCompletionProgressVo.getUserName(),"").equals(ObjectUtils.defaultIfNull(record.getUserName(),""))
                  && ObjectUtils.defaultIfNull(visitCompletionProgressVo.getVisitDate(),"").equals(ObjectUtils.defaultIfNull(record.getVisitDate(),""))
      ).collect(Collectors.toList());
    }
    if(VisitStatisticalType.MONTH.getDictCode().equals(visitStatisticalType.getDictCode())){
      return completionProgressVos.stream().filter(
          visitCompletionProgressVo ->
                  ObjectUtils.defaultIfNull(visitCompletionProgressVo.getUserName(),"").equals(ObjectUtils.defaultIfNull(record.getUserName(),""))
                  && ObjectUtils.defaultIfNull(visitCompletionProgressVo.getVisitDate(),"").startsWith(ObjectUtils.defaultIfNull(record.getVisitDate(),""))
      ).collect(Collectors.toList());
    }
    return null;
  }


}
