package com.biz.crm.sfa.admin.web.report.vo;

import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRecordPictureVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 考勤明细报表的vo
 * @author: rentao
 * @date: 2022/7/5 12:19
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceRecordDetailVo", description = "考勤明细报表的vo")
public class AttendanceRecordDetailVo  extends UuidFlagOpVo {

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  private String ruleId;

  /**
   * 规则编码
   */
  @ApiModelProperty("规则编码")
  private String ruleCode;

  /**
   * 规则名称
   */
  @ApiModelProperty("规则名称")
  private String ruleName;

  /**
   * 规则类型
   */
  @ApiModelProperty("规则类型（static 固定时间上下班规则 free 自由签到 free_time 自由时间上下班规则）")
  private String ruleType;

  /**
   * 打卡类型(on_work:上班打卡,off_work:下班打卡)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType
   */
  @ApiModelProperty("打卡类型(on_work:上班打卡,off_work:下班打卡,FREE 自由签到)")
  private String clockType;

  /**
   * 考勤日期(yyyy-MM-dd)
   */
  @ApiModelProperty("考勤日期(yyyy-MM-dd)")
  private String ruleDate;

  /**
   * 打卡时间(HH:mm:ss)
   */
  @ApiModelProperty("打卡时间(HH:mm:ss)")
  private String clockTime;

  /**
   * 考勤地址
   */
  @ApiModelProperty("考勤地址")
  private String clockPlace;

  /**
   * 打卡地点经度
   */
  @ApiModelProperty("打卡地点经度")
  private BigDecimal clockLongitude;

  /**
   * 打卡地点地点纬度
   */
  @ApiModelProperty("打卡地点地点纬度")
  private BigDecimal clockLatitude;

  /**
   * 打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus
   */
  @ApiModelProperty("打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退)")
  private String clockStatus;

  /**
   * 打卡地点状态(ok:正常;ex:异常)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendancePlaceStatus
   */
  @ApiModelProperty("打卡地点状态(ok:正常;ex:异常)")
  private String clockPlaceStatus;

  /**
   * 打卡人员账号
   */
  @ApiModelProperty("打卡人员账号")
  private String userName;

  /**
   * 打卡人员名字
   */
  @ApiModelProperty("打卡人员名字")
  private String userRealName;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 考勤照片
   */
  @ApiModelProperty("考勤照片")
  private  List<AttendanceRecordPictureVo>  pictureList;
}
