package com.biz.crm.sfa.admin.web.report.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 月度考勤vo
 * @author: rentao
 * @date: 2022/7/4 15:30
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceRecordMonthVo", description = "月度考勤vo")
public class AttendanceRecordMonthVo extends UuidVo {

  @ApiModelProperty("考勤日期(yyyy)")
  private String ruleYear;

  @ApiModelProperty("考勤日期(MM)")
  private String ruleMonth;

  @ApiModelProperty("账号")
  private String userName;

  @ApiModelProperty("人员姓名")
  private String userRealName;

  @ApiModelProperty("职位编码")
  private String postCode;

  @ApiModelProperty("职位名称")
  private String postName;

  @ApiModelProperty("组织编码")
  private String orgCode;

  @ApiModelProperty("组织名称")
  private String orgName;

  @ApiModelProperty("加班")
  private BigDecimal overtimeDays = new BigDecimal(0);

  @ApiModelProperty("总时长")
  private BigDecimal allTimes =  BigDecimal.ZERO;

  @ApiModelProperty("迟到")
  private Integer lateDays = 0;

  @ApiModelProperty("早退")
  private Integer earlyDays = 0;

  @ApiModelProperty("请假")
  private BigDecimal leaveDays = new BigDecimal(0);

  @ApiModelProperty("正常出勤")
  private BigDecimal normal =  BigDecimal.ZERO;

  @ApiModelProperty("休息")
  private BigDecimal offDays =  BigDecimal.ZERO;

  @ApiModelProperty("旷工")
  private BigDecimal absenteeismDays = new BigDecimal(0);
}
