package com.biz.crm.sfa.admin.web.report.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * @description: 拜访完成进度vo
 * @author: rentao
 * @date: 2022/7/6 14:31
 */
@Data
@ApiModel(value = "VisitCompletionProgressPageDto", description = "拜访完成进度vo")
public class VisitCompletionProgressVo extends UuidOpVo {

  @ApiModelProperty("人员姓名")
  private String realName;

  @ApiModelProperty("人员账号")
  private String userName;

  @ApiModelProperty("职位名称")
  private String postName;

  @ApiModelProperty("职位编码")
  private String postCode;

  @ApiModelProperty("职位编码")
  private String orgCode;

  @ApiModelProperty("职位名称")
  private String orgName;

  @ApiModelProperty("日期")
  private String visitDate;

  @ApiModelProperty("类型 拜访 协防")
  private String visitType;

  @ApiModelProperty("拜访计划数量")
  private Long visitCount;

  @ApiModelProperty("拜访计划完成数")
  private Long visitComplet;

  @ApiModelProperty("拜访计划未完成数")
  private Long visitNoComplet;

  @ApiModelProperty("拜访计划进行中")
  private Long visitUnder;

  @ApiModelProperty("拜访计划异常数")
  private Long visitException;

  @ApiModelProperty("拜访计划百分比")
  private String visitPercentum;

  @ApiModelProperty("协访计划数量")
  private Long helpCount;

  @ApiModelProperty("协访完成数量")
  private Long helpComplet;

  @ApiModelProperty("协访未完成数量")
  private Long helpNoComplet;

  @ApiModelProperty("协访异常")
  private Long helpException;

  @ApiModelProperty("协访进行中")
  private Long helpUnder;

  @ApiModelProperty("协访百分比")
  private String helpPercentum;

  @ApiModelProperty("协访/拜访状态")
  private String visitStatus;

  @ApiModelProperty("拜访id集合")
  private List<String> visitId;

  @ApiModelProperty("协防id集合")
  private List<String> helpId;
}
