package com.biz.crm.sfa.admin.web.strategy.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.mdm.business.user.sdk.constant.UserConstant;
import com.biz.crm.mdm.business.user.sdk.service.UserValidityCheckService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.admin.web.strategy.DefaultAuthenticationDecisionStrategy;
import com.bizunited.nebula.common.util.Aes128Utils;
import com.bizunited.nebula.security.sdk.event.AuthenticationDecisionStrategy;
import com.bizunited.nebula.security.sdk.event.DecisionTypes;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

import java.nio.charset.StandardCharsets;

/**
 * 手机号 + 密码方式策略实现
 *
 * @author pengxi
 */
@Slf4j
@Component
public class DefaultPhoneAndPasswordStrategy extends DefaultAuthenticationDecisionStrategy implements AuthenticationDecisionStrategy {

  @Autowired
  private UserValidityCheckService userValidityCheckService;

  @Override
  public DecisionTypes type() {
    return DecisionTypes.PHONEANDPASSWORD;
  }

  @Override
  public boolean onAuthenticate(LoginDetails loginDetails) {
    /*
     * 处理过程如下：
     * 1、首先通过手机号查询当前用户并检查用户有效性
     * 2、检查登录密码是否正确
     * 3、填充security鉴权必要信息：tenantCode,account,password
     * 4、然后完善登录信息中的用户基本信息
     * 5、最后完善登录信息中的岗位组织等信息
     */
    LoginUserDetails loginUserDetails = (LoginUserDetails) loginDetails;
    log.info("HttpServletRequest phone:{}", loginUserDetails.getPhone());
    log.info("HttpServletRequest password:{}", loginUserDetails.getPassword());
    Validate.notBlank(loginUserDetails.getPhone(), "登录手机号不能为空！");
    Validate.notBlank(loginUserDetails.getPassword(), "登录密码不能为空！");
    String phone = Aes128Utils.decrypt(loginUserDetails.getPhone(), UserConstant.ENCRYPT_KEY, Aes128Utils.EncodeType.CBC, Aes128Utils.Padding.PKCS_7_PADDING);
    log.error("account decrypt:{}", phone);
    String password = Aes128Utils.decrypt(loginUserDetails.getPassword(), UserConstant.ENCRYPT_KEY, Aes128Utils.EncodeType.CBC, Aes128Utils.Padding.PKCS_7_PADDING);
    log.error("password decrypt:{}", password);
    // 1、
    UserVo userVo = this.userValidityCheckService.verificationManageByPhone(phone);
    Validate.notNull(userVo, "当前系统不存在此手机号，请联系管理员！");
    // 2、密码校验过程先按与前端约定的加密方式做解密，然后md5再做校验
    String passwordEncryption = DigestUtils.md5DigestAsHex(password.getBytes(StandardCharsets.UTF_8));
    Validate.isTrue(passwordEncryption.equals(userVo.getUserPassword()), "登录密码错误！");
    // 3、4、
    loginUserDetails.setType(DecisionTypes.PHONEANDPASSWORD.getCode());
    super.perfectLoginUserDetails(userVo, loginUserDetails);
    // 5、
    super.perfectLoginPostAndOrg(loginUserDetails);
    return true;
  }
}
