package com.biz.crm.sfa.admin.web.exports.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.ActionTpmExecuteExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.ActionTpmExecuteExportVo;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmExecuteService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * TPM活动执行信息导出
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Component
public class ActionTpmExecuteExportProcess implements ExportProcess<ActionTpmExecuteExportVo> {

  @Autowired(required = false)
  private ActionTpmExecuteService actionTpmExecuteService;

  @Override
  public Class findCrmExcelVoClass() {
    return ActionTpmExecuteExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_ACTION_TPM_EXECUTE_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA TPM活动执行导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    ActionTpmExecuteExportDto dto = this.convertParams(params);
    Page<ActionTpmExecuteEntity> entityPage = this.actionTpmExecuteService.findByConditions(PageRequest.of(0, 1), dto);
    return ((int) (entityPage.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    ActionTpmExecuteExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<ActionTpmExecuteEntity> page = this.actionTpmExecuteService.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
  }

  /**
   * 调整数据
   *
   * @param data 待调整数据
   * @return 调整后数据
   */
  private List<ActionTpmExecuteExportVo> adjustData(List<ActionTpmExecuteEntity> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    List<ActionTpmExecuteExportVo> exportVos = new ArrayList<>();
    for (ActionTpmExecuteEntity datum : data) {
      ActionTpmExecuteExportVo exportVo = new ActionTpmExecuteExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVo.setCreateTime(DateUtil.formatDateTime(datum.getCreateTime()));
      exportVo.setActionStartDate(DateUtil.formatDateTime(datum.getActionStartDate()));
      exportVo.setActionEndDate(DateUtil.formatDateTime(datum.getActionEndDate()));
      exportVos.add(exportVo);
    }
    return exportVos;
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private ActionTpmExecuteExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    ActionTpmExecuteExportDto dto = JSON.parseObject(JSON.toJSONString(params), ActionTpmExecuteExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
