package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.AttendanceFillApplyExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.AttendanceFillApplyExportVo;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceFillApplyVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceFillApplyVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description: 补打卡申请明细导出
 * @author: rentao
 * @date: 2022/7/8 16:36
 */
@Component
public class AttendanceFillApplyExportProcess implements ExportProcess<AttendanceFillApplyExportVo> {

  @Autowired
  private AttendanceFillApplyVoService attendanceFillApplyVoService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    AttendanceFillApplyExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(0, 50);
    long total = this.attendanceFillApplyVoService.findDetailByConditions(pageable, dto).getTotal();
    return Math.toIntExact(total);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    AttendanceFillApplyExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<AttendanceFillApplyVo> page = this.attendanceFillApplyVoService.findDetailByConditions(pageable, dto);
    //调整数据
    List<AttendanceFillApplyVo> records = page.getRecords();
    List<AttendanceFillApplyExportVo> data = this.adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  @Override
  public Class<AttendanceFillApplyExportVo> findCrmExcelVoClass() {
    return AttendanceFillApplyExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_ATTENDANCE_FILL_APPLY_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "补打卡报表导出";
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private AttendanceFillApplyExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    AttendanceFillApplyExportDto dto = JSON.parseObject(JSON.toJSONString(params), AttendanceFillApplyExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<AttendanceFillApplyExportVo> adjustData(List<AttendanceFillApplyVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    List<AttendanceFillApplyExportVo> exportVos = new ArrayList<>();
    for (AttendanceFillApplyVo datum : data) {
      AttendanceFillApplyExportVo exportVo = new AttendanceFillApplyExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVos.add(exportVo);
    }
    return exportVos;
  }
}
