package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.AttendanceRecordMonthExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.AttendanceRecordMonthExportVo;
import com.biz.crm.sfa.admin.web.report.service.AttendanceRecordMonthVoService;
import com.biz.crm.sfa.admin.web.report.vo.AttendanceRecordMonthVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description: 月度考勤报表
 * @author: rentao
 * @date: 2022/7/8 16:12
 */
@Component
public class AttendanceRecordMonthExportProcess implements ExportProcess<AttendanceRecordMonthExportVo> {

  @Autowired
  private AttendanceRecordMonthVoService attendanceHistoryVoService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    AttendanceRecordMonthExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(0, 50);
    long total = this.attendanceHistoryVoService.findByConditions(pageable, dto).getTotal();
    return Math.toIntExact(total);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    AttendanceRecordMonthExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<AttendanceRecordMonthVo> page = this.attendanceHistoryVoService.findByConditions(pageable, dto);
    //调整数据
    List<AttendanceRecordMonthVo> records = page.getRecords();
    List<AttendanceRecordMonthExportVo> data = this.adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  @Override
  public Class<AttendanceRecordMonthExportVo> findCrmExcelVoClass() {
    return AttendanceRecordMonthExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_ATTENDANCE_RECORD_MONTH_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "月度考勤计划导出";
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private AttendanceRecordMonthExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    AttendanceRecordMonthExportDto dto = JSON.parseObject(JSON.toJSONString(params), AttendanceRecordMonthExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<AttendanceRecordMonthExportVo> adjustData(List<AttendanceRecordMonthVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    List<AttendanceRecordMonthExportVo> exportVos = new ArrayList<>();
    for (AttendanceRecordMonthVo datum : data) {
      AttendanceRecordMonthExportVo exportVo = new AttendanceRecordMonthExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVos.add(exportVo);
    }
    return exportVos;
  }
}
