package com.biz.crm.sfa.admin.web.exports.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.sfa.admin.web.constant.DictCodeConstant;
import com.biz.crm.sfa.admin.web.exports.dto.CompetingGoodsCollectExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.CompetingGoodsCollectExportVo;
import com.biz.crm.sfa.admin.web.utils.DictValueUtil;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollect;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsCollectService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author songjigne
 * @describe: 竞品分析报表导出
 * @createTime 2022年05月23日 21:16:00
 */
@Component
public class CompetingGoodsCollectExportExportProcess implements ExportProcess<CompetingGoodsCollectExportVo> {

  @Autowired
  private CompetingGoodsCollectService competingGoodsCollectService;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public Class findCrmExcelVoClass() {
    return CompetingGoodsCollectExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_COMPETING_GOODS_COLLECT_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA竞品分析导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    CompetingGoodsCollectExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(1, 1);
    Page<CompetingGoodsCollect> page = this.competingGoodsCollectService.findByConditions(pageable, dto);
    long total = page.getTotal();
    return Long.valueOf(total).intValue();
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    CompetingGoodsCollectExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<CompetingGoodsCollect> page = this.competingGoodsCollectService.findByConditions(pageable, dto);
    //调整数据
    List<CompetingGoodsCollect> records = page.getRecords();
    List<CompetingGoodsCollectExportVo> data = adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<CompetingGoodsCollectExportVo> adjustData(List<CompetingGoodsCollect> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    //转换数据字典值
    Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DictCodeConstant.DICT_CLIENT_TYPE));
    List<CompetingGoodsCollectExportVo> exportVos = new ArrayList<>();
    for (CompetingGoodsCollect datum : data) {
      CompetingGoodsCollectExportVo exportVo = new CompetingGoodsCollectExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVo.setCreateTime(DateUtil.formatDateTime(datum.getCreateTime()));
      exportVo.setClientType(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_CLIENT_TYPE, datum.getClientType()));
      exportVos.add(exportVo);
    }
    return exportVos;
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private CompetingGoodsCollectExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    CompetingGoodsCollectExportDto dto = JSON.parseObject(JSON.toJSONString(params), CompetingGoodsCollectExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
