package com.biz.crm.sfa.admin.web.exports.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.HolidayExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.HolidayExportVo;
import com.biz.crm.sfa.business.holiday.sdk.service.HolidayVoService;
import com.biz.crm.sfa.business.holiday.sdk.vo.HolidayVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 节假日导出
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Component
public class HolidayExportProcess implements ExportProcess<HolidayExportVo> {

  @Autowired(required = false)
  private HolidayVoService holidayVoService;

  @Override
  public Class findCrmExcelVoClass() {
    return HolidayExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_HOLIDAY_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA节假日导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    HolidayExportDto dto = this.convertParams(params);
    Page<HolidayVo> entityPage = this.holidayVoService.findByConditions(PageRequest.of(0, 1), dto);
    return ((int) (entityPage.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    HolidayExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<HolidayVo> page = this.holidayVoService.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
  }

  /**
   * 调整数据
   *
   * @param data 待调整数据
   * @return 调整后数据
   */
  private List<HolidayExportVo> adjustData(List<HolidayVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    List<HolidayExportVo> exportVos = new ArrayList<>();
    for (HolidayVo datum : data) {
      HolidayExportVo exportVo = new HolidayExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVo.setCreateTime(DateUtil.formatDateTime(datum.getCreateTime()));
      exportVo.setModifyTime(DateUtil.formatDateTime(datum.getModifyTime()));
      exportVos.add(exportVo);
    }
    return exportVos;
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private HolidayExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    HolidayExportDto dto = JSON.parseObject(JSON.toJSONString(params), HolidayExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
