package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.IntegralCountExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.IntegralCountExportVo;
import com.biz.crm.sfa.business.integral.local.service.IntegralReportService;
import com.biz.crm.sfa.business.integral.sdk.vo.IntegralCountVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description: 积分明细排名导出
 * @author: rentao
 * @date: 2022/7/8 15:37
 */
@Component
public class IntegralCountExportProcess implements ExportProcess<IntegralCountExportVo> {

  @Autowired
  private IntegralReportService integralReportService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    IntegralCountExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(0, 50);
    long total = this.integralReportService.findIntegralCountByConditions(pageable, dto).getTotal();
    return Math.toIntExact(total);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    IntegralCountExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<IntegralCountVo> page = this.integralReportService.findIntegralCountByConditions(pageable, dto);
    //调整数据
    List<IntegralCountVo> records = page.getRecords();
    List<IntegralCountExportVo> data = this.adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  @Override
  public Class<IntegralCountExportVo> findCrmExcelVoClass() {
    return IntegralCountExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_INTEGRAL_COUNT_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "积分排名导出";
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private IntegralCountExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    IntegralCountExportDto dto = JSON.parseObject(JSON.toJSONString(params), IntegralCountExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<IntegralCountExportVo> adjustData(List<IntegralCountVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    List<IntegralCountExportVo> exportVos = new ArrayList<>();
    for (IntegralCountVo datum : data) {
      IntegralCountExportVo exportVo = new IntegralCountExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVos.add(exportVo);
    }
    return exportVos;
  }
}
