package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.vo.IntegralExportVo;
import com.biz.crm.sfa.business.integral.local.entity.Integral;
import com.biz.crm.sfa.business.integral.local.service.IntegralService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description: 积分明细导出
 * @author: rentao
 * @date: 2022/7/8 15:23
 */
@Component
public class IntegralExportProcess implements ExportProcess<IntegralExportVo> {

  @Autowired
  private IntegralService integralService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    Integral dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(0, 50);
    long total = this.integralService.findByConditions(pageable, dto).getTotal();
    return Math.toIntExact(total);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    Integral dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<Integral> page = this.integralService.findByConditions(pageable, dto);
    //调整数据
    List<Integral> records = page.getRecords();
    List<IntegralExportVo> data = this.adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  @Override
  public Class<IntegralExportVo> findCrmExcelVoClass() {
    return IntegralExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_INTEGRAL_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "积分明细导出";
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private Integral convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    Integral dto = JSON.parseObject(JSON.toJSONString(params), Integral.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<IntegralExportVo> adjustData(List<Integral> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    List<IntegralExportVo> exportVos = new ArrayList<>();
    for (Integral datum : data) {
      IntegralExportVo exportVo = new IntegralExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVos.add(exportVo);
    }
    return exportVos;
  }
}
