package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.SfaLeaveDetailExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.SfaLeaveDetailExportVo;
import com.biz.crm.sfa.business.leave.sdk.service.SfaLeaveVoService;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * 请假明细导出
 *
 * @author jerry7
 */
@Component
public class SfaLeaveDetailExportProcess implements ExportProcess<SfaLeaveDetailExportVo> {

  @Autowired(required = false)
  private SfaLeaveVoService sfaLeaveVoService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Class findCrmExcelVoClass() {
    return SfaLeaveDetailExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_LEAVE_DETAIL_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA请假明细导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    SfaLeaveDetailExportDto dto = this.convertParams(params);
    Page<SfaLeaveVo> entityPage = this.sfaLeaveVoService.findByConditions(PageRequest.of(0, 1), dto);
    return ((int) (entityPage.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    SfaLeaveDetailExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<SfaLeaveVo> page = this.sfaLeaveVoService.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
  }

  /**
   * 调整数据
   *
   * @param data 待调整数据
   * @return 调整后数据
   */
  private List<SfaLeaveDetailExportVo> adjustData(List<SfaLeaveVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return Lists.newArrayList();
    }
    return (List<SfaLeaveDetailExportVo>) this.nebulaToolkitService.copyCollectionByWhiteList(data, SfaLeaveVo.class, SfaLeaveDetailExportVo.class, HashSet.class, ArrayList.class);
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private SfaLeaveDetailExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    SfaLeaveDetailExportDto dto = JSON.parseObject(JSON.toJSONString(params), SfaLeaveDetailExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
