package com.biz.crm.sfa.admin.web.exports.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.sfa.admin.web.constant.DictCodeConstant;
import com.biz.crm.sfa.admin.web.exports.dto.SignInGroupExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.SignInGroupExportVo;
import com.biz.crm.sfa.admin.web.utils.DictValueUtil;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupEntity;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 签到组导出
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Component
public class SignInGroupExportProcess implements ExportProcess<SignInGroupExportVo> {

  @Autowired(required = false)
  private SignInGroupService signInGroupService;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public Class findCrmExcelVoClass() {
    return SignInGroupExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_SIGN_IN_GROUP_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA签到组导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    SignInGroupExportDto dto = this.convertParams(params);
    Page<SignInGroupEntity> entityPage = this.signInGroupService.findByConditions(PageRequest.of(0, 1), dto);
    return ((int) (entityPage.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    SignInGroupExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<SignInGroupEntity> page = this.signInGroupService.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
  }

  /**
   * 调整数据
   *
   * @param data 待调整数据
   * @return 调整后数据
   */
  private List<SignInGroupExportVo> adjustData(List<SignInGroupEntity> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    Map<String, List<DictDataVo>> mapDict = this.dictDataVoService
        .findByDictTypeCodeList(Lists.newArrayList(DictCodeConstant.TIME_TYPE, DictCodeConstant.DICT_ENABLE));
    List<SignInGroupExportVo> exportVos = new ArrayList<>();
    for (SignInGroupEntity datum : data) {
      SignInGroupExportVo exportVo = new SignInGroupExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVo.setCreateTime(DateUtil.formatDateTime(datum.getCreateTime()));
      exportVo.setModifyTime(DateUtil.formatDateTime(datum.getModifyTime()));
      exportVo.setEnableStatus(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_ENABLE, datum.getEnableStatus()));
      exportVo.setTimeType(DictValueUtil.findDictValue(mapDict, DictCodeConstant.TIME_TYPE, datum.getTimeType()));
      exportVos.add(exportVo);
    }
    return exportVos;
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private SignInGroupExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    SignInGroupExportDto dto = JSON.parseObject(JSON.toJSONString(params), SignInGroupExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
