package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.StoreInspectExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.StoreInspectExportVo;
import com.biz.crm.sfa.business.template.store.local.entity.StoreInspectEntity;
import com.biz.crm.sfa.business.template.store.local.service.StoreInspectService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * 店铺检查导出
 *
 * @author jerry7
 */
@Component
public class StoreInspectExportProcess implements ExportProcess<StoreInspectExportVo> {

  @Autowired
  private StoreInspectService storeInspectService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Class findCrmExcelVoClass() {
    return StoreInspectExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_STORE_INSPECT_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA店面检查导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    StoreInspectExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(0, 1);
    Page<StoreInspectEntity> page = this.storeInspectService.findByConditions(pageable, dto);
    long total = page.getTotal();
    return Long.valueOf(total).intValue();
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    StoreInspectExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<StoreInspectEntity> page = this.storeInspectService.findByConditions(pageable, dto);
    //调整数据
    List<StoreInspectEntity> records = page.getRecords();
    List<StoreInspectExportVo> data = adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<StoreInspectExportVo> adjustData(List<StoreInspectEntity> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    return (List<StoreInspectExportVo>) this.nebulaToolkitService.copyCollectionByWhiteList(data, StoreInspectEntity.class,StoreInspectExportVo.class, HashSet.class, ArrayList.class);
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private StoreInspectExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    StoreInspectExportDto dto = JSON.parseObject(JSON.toJSONString(params), StoreInspectExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
