package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.TravelApplyDetailExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.TravelApplyDetailExportVo;
import com.biz.crm.sfa.business.travel.sdk.service.TravelApplyDetailVoService;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description: 出差申请明细导出
 * @author: rentao
 * @date: 2022/7/8 16:47
 */
@Component
public class TravelApplyDetailExportProcess implements ExportProcess<TravelApplyDetailExportVo> {

  @Autowired
  private TravelApplyDetailVoService travelApplyDetailVoService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    TravelApplyDetailExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(0, 50);
    long total = this.travelApplyDetailVoService.findByConditions(pageable, dto).getTotal();
    return Math.toIntExact(total);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    TravelApplyDetailExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<TravelApplyDetailVo> page = this.travelApplyDetailVoService.findByConditions(pageable, dto);
    //调整数据
    List<TravelApplyDetailVo> records = page.getRecords();
    List<TravelApplyDetailExportVo> data = this.adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  @Override
  public Class<TravelApplyDetailExportVo> findCrmExcelVoClass() {
    return TravelApplyDetailExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_TRAVEL_APPLY_DETAIL_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "出差申请明细导出";
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private TravelApplyDetailExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    TravelApplyDetailExportDto dto = JSON.parseObject(JSON.toJSONString(params), TravelApplyDetailExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<TravelApplyDetailExportVo> adjustData(List<TravelApplyDetailVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    List<TravelApplyDetailExportVo> exportVos = new ArrayList<>();
    for (TravelApplyDetailVo datum : data) {
      TravelApplyDetailExportVo exportVo = new TravelApplyDetailExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVos.add(exportVo);
    }
    return exportVos;
  }
}
