package com.biz.crm.sfa.admin.web.exports.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.sfa.admin.web.constant.DictCodeConstant;
import com.biz.crm.sfa.admin.web.exports.dto.VisitPlanDetailExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.VisitPlanDetailExportVo;
import com.biz.crm.sfa.admin.web.utils.DictValueUtil;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailVoService;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author songjigne
 * @describe: 拜访计划报表导出
 * @createTime 2022年05月23日 21:16:00
 */
@Component
public class VisitPlanDetailExportProcess implements ExportProcess<VisitPlanDetailExportVo> {

  @Autowired
  private VisitPlanDetailVoService visitPlanDetailVoService;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public Class findCrmExcelVoClass() {
    return VisitPlanDetailExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_VISIT_PLAN_DETAIL_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA拜访计划明细导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    VisitPlanDetailExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(1, 1);
    Page<VisitPlanDetailVo> page = this.visitPlanDetailVoService.findByConditions(pageable, dto);
    long total = page.getTotal();
    return Long.valueOf(total).intValue();
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    VisitPlanDetailExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<VisitPlanDetailVo> page = this.visitPlanDetailVoService.findByConditions(pageable, dto);
    //调整数据
    List<VisitPlanDetailVo> records = page.getRecords();
    List<VisitPlanDetailExportVo> data = adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<VisitPlanDetailExportVo> adjustData(List<VisitPlanDetailVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    //转换数据字典值
    Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(
        DictCodeConstant.DICT_CLIENT_TYPE,
        DictCodeConstant.VISIT_PLAN_TYPE,
        DictCodeConstant.VISIT_STATUS
    ));
    List<VisitPlanDetailExportVo> exportVos = new ArrayList<>();
    for (VisitPlanDetailVo datum : data) {
      VisitPlanDetailExportVo exportVo = new VisitPlanDetailExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVo.setCreateTime(DateUtil.formatDateTime(datum.getCreateTime()));
      exportVo.setVisitDate(DateFormatUtils.format(datum.getVisitDate(), "yyyy-MM-dd"));
      exportVo.setClientType(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_CLIENT_TYPE, datum.getClientType()));
      exportVo.setVisitPlanType(DictValueUtil.findDictValue(mapDict, DictCodeConstant.VISIT_PLAN_TYPE, datum.getVisitPlanType()));
      exportVo.setVisitStatus(DictValueUtil.findDictValue(mapDict, DictCodeConstant.VISIT_STATUS, datum.getVisitPlanType()));
      exportVos.add(exportVo);
    }
    return exportVos;
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private VisitPlanDetailExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    VisitPlanDetailExportDto dto = JSON.parseObject(JSON.toJSONString(params), VisitPlanDetailExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
