package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.sfa.admin.web.exports.dto.WorkTaskReportExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.WorkTaskReportExportVo;
import com.biz.crm.sfa.business.work.task.sdk.service.WorkTaskReportVoService;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description: 临时工作任务导出
 * @author: rentao
 * @date: 2022/7/8 14:40
 */
@Component
public class WorkTaskReportExportProcess implements ExportProcess<WorkTaskReportExportVo> {

  @Autowired
  private WorkTaskReportVoService workTaskReportVoService;
  @Autowired
  private DictDataVoService dictDataVoService;


  @Override
  public Integer getTotal(Map<String, Object> params) {
    WorkTaskReportExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(0, 50);
    long total = workTaskReportVoService.findByConditions(pageable, dto).getTotal();
    return Math.toIntExact(total);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    WorkTaskReportExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<WorkTaskReportVo> page = this.workTaskReportVoService.findByConditions(pageable, dto);
    //调整数据
    List<WorkTaskReportVo> records = page.getRecords();
    List<WorkTaskReportExportVo> data = this.adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  @Override
  public Class<WorkTaskReportExportVo> findCrmExcelVoClass() {
    return WorkTaskReportExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_WORK_TASK_REPORT_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "临时任务导出";
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private WorkTaskReportExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    WorkTaskReportExportDto dto = JSON.parseObject(JSON.toJSONString(params), WorkTaskReportExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<WorkTaskReportExportVo> adjustData(List<WorkTaskReportVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    List<WorkTaskReportExportVo> exportVos = new ArrayList<>();
    for (WorkTaskReportVo datum : data) {
      WorkTaskReportExportVo exportVo = new WorkTaskReportExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVos.add(exportVo);
    }
    return exportVos;
  }
}
