package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @description: 考勤明细报表导出vo
 * @author: rentao
 * @date: 2022/7/8 15:54
 */
@Data
@CrmExcelExport
@ApiModel(value = "AttendanceRecordDetailExportVo", description = "考勤明细报表导出vo")
public class AttendanceRecordDetailExportVo extends CrmExcelVo {

  /**
   * 规则编码
   */
  @CrmExcelColumn("规则编码")
  private String ruleCode;

  /**
   * 规则名称
   */
  @CrmExcelColumn("规则名称")
  private String ruleName;

  /**
   * 规则类型
   */
  @CrmExcelColumn("规则类型")
  private String ruleType;

  /**
   * 打卡类型(on_work:上班打卡,off_work:下班打卡)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType
   */
  @CrmExcelColumn("打卡类型(on_work:上班打卡,off_work:下班打卡)")
  private String clockType;

  /**
   * 考勤日期(yyyy-MM-dd)
   */
  @CrmExcelColumn("考勤日期(yyyy-MM-dd)")
  private String ruleDate;

  /**
   * 打卡时间(HH:mm:ss)
   */
  @CrmExcelColumn("打卡时间(HH:mm:ss)")
  private String clockTime;

  /**
   * 考勤地址
   */
  @CrmExcelColumn("考勤地址")
  private String clockPlace;

  /**
   * 打卡地点经度
   */
  @CrmExcelColumn("打卡地点经度")
  private BigDecimal clockLongitude;

  /**
   * 打卡地点地点纬度
   */
  @CrmExcelColumn("打卡地点地点纬度")
  private BigDecimal clockLatitude;

  /**
   * 打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus
   */
  @CrmExcelColumn("打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退)")
  private String clockStatus;

  /**
   * 打卡地点状态(ok:正常;ex:异常)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendancePlaceStatus
   */
  @CrmExcelColumn("打卡地点状态(ok:正常;ex:异常)")
  private String clockPlaceStatus;

  /**
   * 打卡人员账号
   */
  @CrmExcelColumn("打卡人员账号")
  private String userName;

  /**
   * 打卡人员名字
   */
  @CrmExcelColumn("打卡人员名字")
  private String userRealName;

  /**
   * 职位编码
   */
  @CrmExcelColumn("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @CrmExcelColumn("职位名称")
  private String positionName;

  /**
   * 所属组织编码
   */
  @CrmExcelColumn("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @CrmExcelColumn("所属组织名称")
  private String orgName;

}
