package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 考勤规则导出vo
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Data
@CrmExcelExport
@ApiModel(value = "AttendanceRuleExportVo", description = "考勤规则导出vo")
public class AttendanceRuleExportVo extends CrmExcelVo {

  /**
   * 规则编码
   */
  @CrmExcelColumn("规则编码")
  private String ruleCode;

  /**
   * 规则名称
   */
  @CrmExcelColumn("规则名称")
  private String ruleName;

  /**
   * 数据业务状态（启用状态）
   */
  @CrmExcelColumn("状态")
  private String enableStatus;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

  /**
   * 创建人
   */
  @CrmExcelColumn("创建人")
  private String createName;

  /**
   * 更新时间
   */
  @CrmExcelColumn("更新时间")
  private String modifyTime;

  /**
   * 更新人
   */
  @CrmExcelColumn("更新人")
  private String modifyName;
}
