package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 潜在客户导出
 *
 * @author songjingen
 */
@Data
@CrmExcelExport
public class ClientPotentialExportVo extends CrmExcelVo {

  private static final long serialVersionUID = -4442779125977878918L;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @CrmExcelColumn("客户类型: terminal-终端，dealer-经销商")
  private String clientType;

  /**
   * 客户名称
   */
  @CrmExcelColumn("客户名称")
  private String clientName;

  /**
   * 客户地址
   */
  @CrmExcelColumn("客户地址")
  private String clientAddress;

  /**
   * 客户电话
   */
  @CrmExcelColumn("客户电话")
  private String clientPhone;

  /**
   * 位置信息：经度
   */
  @CrmExcelColumn("位置信息:经度")
  private BigDecimal longitude;

  /**
   * 位置信息：纬度
   */
  @CrmExcelColumn("位置信息:纬度")
  private BigDecimal latitude;

  /**
   * 关联人员账号
   */
  @CrmExcelColumn("人员账号")
  private String userName;

  /**
   * 关联人员姓名
   */
  @CrmExcelColumn("人员姓名")
  private String fullName;

}
