package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import io.swagger.annotations.ApiModel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 竞品分析导出vo
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CompetingGoodsCollectExportVo", description = "竞品分析导出vo")
@CrmExcelExport
public class CompetingGoodsCollectExportVo extends CrmExcelVo {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 客户编码
   */
  @CrmExcelColumn("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @CrmExcelColumn("客户名称")
  private String clientName;

  /**
   * 客户类别
   *
   * @see ClientTypeEnum#getDictCode()
   */
  @CrmExcelColumn("客户分类")
  private String clientType;

  /**
   * 提交人登录账号
   */
  @CrmExcelColumn("提交人登录账号")
  private String createAccount;

  /**
   * 提交人姓名
   */
  @CrmExcelColumn("提交人姓名")
  private String createName;

  /**
   * 提交人职位
   */
  @CrmExcelColumn("提交人职位")
  private String postName;

  /**
   * 提交时间
   */
  @CrmExcelColumn("提交时间")
  private String createTime;


}
