package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 竞品商品导出vo
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CompetingGoodsExportVo", description = "竞品商品导出vo")
@CrmExcelExport
public class CompetingGoodsExportVo extends CrmExcelVo {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 竞品名称
   */
  @CrmExcelColumn("竞品名称")
  private String goodsName;

  /**
   * 所属品牌
   */
  @CrmExcelColumn("所属品牌")
  private String goodsBrand;
  /**
   * 所属系列
   */
  @CrmExcelColumn("所属系列")
  private String goodsSerial;

  /**
   * 数据业务状态（启用状态）
   */
  @CrmExcelColumn("状态")
  private String enableStatus;

  /**
   * 创建人
   */
  @CrmExcelColumn("创建人")
  private String createName;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

  /**
   * 更新人
   */
  @CrmExcelColumn("更新人")
  private String modifyName;

  /**
   * 更新时间
   */
  @CrmExcelColumn("更新时间")
  private String modifyTime;


}
