package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 协访计划制定导出vo
 *
 * @author songjingen
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@CrmExcelExport
@ApiModel(value = "HelpDefenseExportVo", description = "协访计划制定导出vo")
public class HelpDefenseExportVo extends CrmExcelVo {

  private static final long serialVersionUID = -4442779125977878918L;

  /**
   * 被协访人员姓名
   */
  @CrmExcelColumn("被协访人员姓名")
  private String coverHelpRealName;

  /**
   * 协访日期
   */
  @CrmExcelColumn("协访日期")
  private String helpDefenseDate;

  /**
   * 协访人员
   */
  @CrmExcelColumn("协访人员")
  private String helpRealName;

  /**
   * 协访人员职位名称
   */
  @CrmExcelColumn("协访人员职位名称")
  private String helpPostName;

  /**
   * 协访人员所属组织名称
   */
  @CrmExcelColumn("协访人员所属组织")
  private String helpOrgName;
  /**
   * 创建人
   */
  @CrmExcelColumn("创建人")
  private String createName;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

}
