package com.biz.crm.sfa.admin.web.exports.vo;


import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import java.math.BigDecimal;

/**
 * 库存盘点导出VO
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "InventoryCheckExportVo", description = "库存盘点导出vo")
public class InventoryCheckExportVo extends CrmExcelVo {

  private static final long serialVersionUID = -8718203111224722645L;
  /**
   * 站点编码
   */
  @ApiModelProperty("站点编码")
  private String clientCode;

  /**
   * 站点名称
   */
  @ApiModelProperty("站点名称")
  private String clientName;

  /**
   * 站点类别
   */
  @ApiModelProperty("站点类别(经销商/终端)")
  private String clientType;

  /**
   * 位置信息：经度
   */
  @ApiModelProperty("位置信息:经度")
  private BigDecimal longitude;

  /**
   * 位置信息：纬度
   */
  @ApiModelProperty("位置信息:纬度")
  private BigDecimal latitude;

  /**
   * 位置信息
   */
  @ApiModelProperty("位置信息")
  private String checkAddress;

  /**
   * 产品层级数量
   */
  @ApiModelProperty("产品层级数量")
  private String productLevelQuantify;

  /**
   * 商品种类数量
   */
  @ApiModelProperty("商品种类数量")
  private String productTypeQuantify;

  /**
   * 商品数量
   */
  @ApiModelProperty("商品数量")
  private String productQuantify;

  /**
   * 用户姓名
   */
  @ApiModelProperty("用户姓名")
  private String userName;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

}
