package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 签到组导出vo
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Data
@CrmExcelExport
@ApiModel(value = "SignInGroupExportVo", description = "签到组导出vo")
public class SignInGroupExportVo extends CrmExcelVo {

  /**
   * 签到组编码
   */
  @CrmExcelColumn("签到组编码")
  private String groupCode;

  /**
   * 签到组名称
   */
  @CrmExcelColumn("签到组")
  private String groupName;

  /**
   * 有效时间类型(long_time:长期有效;diy_time:自定义有效期)
   *
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInTimeType
   */
  @CrmExcelColumn("有效时间类型")
  private String timeType;

  /**
   * 数据业务状态（启用状态）
   */
  @CrmExcelColumn("状态")
  private String enableStatus;

  /**
   * 创建人
   */
  @CrmExcelColumn("创建人")
  private String createName;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

  /**
   * 更新人
   */
  @CrmExcelColumn("更新人")
  private String modifyName;

  /**
   * 更新时间
   */
  @CrmExcelColumn("更新时间")
  private String modifyTime;


}
