package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 拜访步骤配置导出vo
 *
 * @author songjingen
 */
@Data
@CrmExcelExport
@ApiModel(value = "StepFormExportVo", description = "拜访步骤配置导出vo")
public class StepRoleExportVo extends CrmExcelVo {

  private static final long serialVersionUID = 7022214277071025864L;

  /**
   * 角色编码
   */
  @CrmExcelColumn("角色编码")
  private String roleCode;

  /**
   * 角色名称
   */
  @CrmExcelColumn("角色名称")
  private String roleName;

  /**
   * 拜访类型
   *
   * @see VisitTypeEnum#getDictCode()
   */
  @CrmExcelColumn("拜访类型")
  private String visitType;

  /**
   * 客户类型
   *
   * @see ClientTypeEnum#getDictCode()
   */
  @CrmExcelColumn("客户类型")
  private String clientType;

  /**
   * 数据业务状态（启用状态）
   */
  @CrmExcelColumn("状态")
  private String enableStatus;

  /**
   * 创建人
   */
  @CrmExcelColumn("创建人")
  private String createName;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

  /**
   * 更新人
   */
  @CrmExcelColumn("更新人")
  private String modifyName;

  /**
   * 更新时间
   */
  @CrmExcelColumn("更新时间")
  private String modifyTime;

}
