package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 店铺检查导出vo
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StoreInspectEntity", description = "店铺检查导出vo")
public class StoreInspectExportVo extends CrmExcelVo {

  private static final long serialVersionUID = -246779396614017344L;
  /**
   * 站点编码
   */
  @ApiModelProperty("站点编码")
  private String clientCode;

  /**
   * 站点名称
   */
  @ApiModelProperty("站点名称")
  private String clientName;

  /**
   * 站点类别
   */
  @ApiModelProperty("站点名称")
  private String clientType;

  /**
   * 位置信息：经度
   */
  @ApiModelProperty("位置信息:经度")
  private BigDecimal longitude;

  /**
   * 位置信息：纬度
   */
  @ApiModelProperty("位置信息:纬度")
  private BigDecimal latitude;

  /**
   * 位置信息
   */
  @ApiModelProperty("位置信息")
  private String checkAddress;

  /**
   * 用户姓名
   */
  @ApiModelProperty("用户姓名")
  private String userName;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 组织编码
   */
  @ApiModelProperty("职位编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty("职位名称")
  private String orgName;

}
