package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 协访评价导出vo
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VisitEvaluateExportVo", description = "协访评价导出vo")
public class VisitEvaluateExportVo extends CrmExcelVo {

  private static final long serialVersionUID = -8528283005139138116L;
  /**
   * 站点编码
   */
  @ApiModelProperty("站点编码")
  private String clientCode;

  /**
   * 站点名称
   */
  @ApiModelProperty("站点名称")
  private String clientName;

  /**
   * 站点类别
   */
  @ApiModelProperty("站点类别(经销商/终端)")
  private String clientType;

  /**
   * 位置信息：经度
   */
  @ApiModelProperty("位置信息:经度")
  private BigDecimal longitude;

  /**
   * 位置信息：纬度
   */
  @ApiModelProperty("位置信息:纬度")
  private BigDecimal latitude;

  /**
   * 位置信息
   */
  @ApiModelProperty("位置信息")
  private String checkAddress;

  /**
   * 协访用户姓名
   */
  @ApiModelProperty("协访用户姓名")
  private String helpUserName;

  /**
   * 协访用户编码
   */
  @ApiModelProperty("协访用户编码")
  private String helpUserCode;

  /**
   * 协访职位编码
   */
  @ApiModelProperty("协访职位编码")
  private String helpPostCode;

  /**
   * 协访职位名称
   */
  @ApiModelProperty("协访职位名称")
  private String helpPostName;

  /**
   * 协访组织编码
   */
  @ApiModelProperty("协访组织编码")
  private String helpOrgCode;

  /**
   * 协访组织名称
   */
  @ApiModelProperty("协访组织名称")
  private String helpOrgName;

  /**
   * 被协访用户姓名
   */
  @ApiModelProperty("被协访用户姓名")
  private String coverHelpUserName;

  /**
   * 被协访用户编码
   */
  @ApiModelProperty("被协访用户编码")
  private String coverHelpUserCode;

  /**
   * 被协访职位编码
   */
  @ApiModelProperty("被协访职位编码")
  private String coverHelpPostCode;

  /**
   * 被协访职位名称
   */
  @ApiModelProperty("被协访职位名称")
  private String coverHelpPostName;

  /**
   * 被协访组织编码
   */
  @ApiModelProperty("被协访组织编码")
  private String coverHelpOrgCode;

  /**
   * 被协访组织名称
   */
  @ApiModelProperty("被协访组织名称")
  private String coverHelpOrgName;

  /**
   * 拜访内容
   */
  @ApiModelProperty("拜访内容")
  private String visitContent;

  /**
   * 问题内容
   */
  @ApiModelProperty("问题内容")
  private String problemContent;

  /**
   * 合格率
   */
  @ApiModelProperty("合格率")
  private String qualifiedRate;

}
