package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitPlanTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 拜访计划明细导出vo
 *
 * @author songjingen
 */
@Data
@CrmExcelExport
@ApiModel(value = "VisitPlanDetailExportVo", description = "拜访计划明细导出vo")
public class VisitPlanDetailExportVo extends CrmExcelVo {

  private static final long serialVersionUID = 7022214277071025864L;

  /**
   * 拜访日期
   */
  @CrmExcelColumn("拜访日期")
  private String visitDate;

  /**
   * 人员姓名
   */
  @CrmExcelColumn("人员姓名")
  private String visitRealName;

  /**
   * 职位名称
   */
  @CrmExcelColumn("职位名称")
  private String visitPostName;

  /**
   * 人员所属组织名称
   */
  @CrmExcelColumn("所属组织")
  private String visitOrgName;

  /**
   * 客户编码
   */
  @CrmExcelColumn("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @CrmExcelColumn("客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @CrmExcelColumn("客户类型")
  private String clientType;

  /**
   * 客户细类
   */
  @CrmExcelColumn("客户细类")
  private String clientSubName;

  /**
   * 拜访状态
   * {@link VisitStatusEnum#getDictCode()}
   */
  @CrmExcelColumn("拜访状态")
  private String visitStatus;

  /**
   * 拜访类型  临时拜访-计划外，计划拜访-计划内
   * <p>
   * {@link VisitPlanTypeEnum#getDictCode()}
   */
  @CrmExcelColumn("拜访计划类型")
  private String visitPlanType;

  /**
   * 创建人
   */
  @CrmExcelColumn("创建人")
  private String createName;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

}
