package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.sfa.business.visit.plan.sdk.register.VisitPlanRouteRegister;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.Date;

/**
 * 拜访计划导出vo
 *
 * @author songjingen
 */
@Data
@CrmExcelExport
@ApiModel(value = "VisitPlanExportVo", description = "拜访计划导出vo")
public class VisitPlanExportVo extends CrmExcelVo {

  private static final long serialVersionUID = 7022214277071025864L;

  /**
   * 拜访计划编码
   */
  @CrmExcelColumn("计划编码")
  private String visitPlanCode;

  /**
   * 人员姓名
   */
  @CrmExcelColumn("人员姓名")
  private String visitRealName;

  /**
   * 人员职位名称
   */
  @CrmExcelColumn("职位名称")
  private String visitPostName;

  /**
   * 人员所属组织名称
   */
  @CrmExcelColumn("所属组织")
  private String visitOrgName;

  /**
   * 维度类型 维度类型（线路组、网点、频率）
   * <p>
   * {@link VisitPlanRouteRegister#getKey()}
   */
  @CrmExcelColumn("规则类型")
  private String visitRouteType;

  /**
   * 数据业务状态（启用状态）
   */
  @CrmExcelColumn("状态")
  private String enableStatus;

  /**
   * 拜访开始时间
   */
  @CrmExcelColumn("开始时间")
  private Date startDate;

  /**
   * 拜访结束时间
   */
  @CrmExcelColumn("结束时间")
  private Date endDate;

  /**
   * 创建人
   */
  @CrmExcelColumn("创建人")
  private String createName;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

  /**
   * 更新人
   */
  @CrmExcelColumn("更新人")
  private String modifyName;

  /**
   * 更新时间
   */
  @CrmExcelColumn("更新时间")
  private String modifyTime;

}
