package com.biz.crm.sfa.admin.web.imports.client.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 潜在客户导入
 *
 * @author songjingen
 */
@Data
@CrmExcelImport
public class ClientPotentialImportVo extends CrmExcelVo {

  private static final long serialVersionUID = -4442779125977878918L;

  /**
   * 客户名称
   */
  @CrmExcelColumn("*客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @CrmExcelColumn("*客户类型（终端/经销商）")
  private String clientType;


  /**
   * 客户地址
   */
  @CrmExcelColumn("*客户地址")
  private String clientAddress;

  /**
   * 电话
   */
  @CrmExcelColumn("电话")
  private String clientPhone;

  /**
   * 位置信息：经度
   */
  @CrmExcelColumn("*经度")
  private BigDecimal longitude;

  /**
   * 位置信息：纬度
   */
  @CrmExcelColumn("*纬度")
  private BigDecimal latitude;

  /**
   * 业务员姓名
   */
  @CrmExcelColumn("*业务员姓名")
  private String fullName;

  /**
   * 业务员账号
   */
  @CrmExcelColumn("*业务员账号")
  private String userName;

}
