package com.biz.crm.sfa.admin.web.listener;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.repository.AttendanceFillApplyVoRepository;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillApplyPageDto;
import com.biz.crm.sfa.business.attendance.sdk.event.AttendanceUpperDataListener;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceFillApplyVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 考勤上层数据获取监听器实现
 *
 * @author ning.zhang
 * @date 2022/9/2
 */
@Component
public class AttendanceUpperDataListenerImpl implements AttendanceUpperDataListener {

  @Autowired
  private AttendanceFillApplyVoRepository attendanceFillApplyVoRepository;

  @Override
  public Page<AttendanceFillApplyVo> findByConditions(Pageable pageable, AttendanceFillApplyPageDto dto) {
    return this.attendanceFillApplyVoRepository.findByConditions(pageable, dto);
  }
}
