package com.biz.crm.sfa.admin.web.listener;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.repository.LeaveVoRepository;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveApplySummaryDto;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveListDto;
import com.biz.crm.sfa.business.leave.sdk.event.LeaveUpperDataListener;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 请假上层数据获取监听器实现
 *
 * @author ning.zhang
 * @date 2022/9/2
 */
@Component
public class LeaveUpperDataListenerImpl implements LeaveUpperDataListener {

  @Autowired
  private LeaveVoRepository leaveVoRepository;

  @Override
  public Page<SfaLeaveVo> findByConditions(Pageable pageable, SfaLeaveListDto sfaLeaveListDto) {
    return this.leaveVoRepository.findByConditions(pageable, sfaLeaveListDto);
  }

  @Override
  public Page<SfaLeaveVo> findSummaryByConditions(Pageable pageable, SfaLeaveApplySummaryDto dto) {
    return this.leaveVoRepository.findSummaryByConditions(pageable, dto);
  }
}
