package com.biz.crm.sfa.admin.web.listener;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.repository.TravelApplyVoRepository;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.event.TravelUpperDataListener;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyDetailVo;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 出差上层数据获取监听器实现
 *
 * @author ning.zhang
 * @date 2022/9/2
 */
@Component
public class TravelUpperDataListenerImpl implements TravelUpperDataListener {

  @Autowired
  private TravelApplyVoRepository travelApplyVoRepository;

  @Override
  public Page<TravelApplyVo> findByConditions(Pageable pageable, TravelApplyPageDto dto) {
    return this.travelApplyVoRepository.findByConditions(pageable, dto);
  }

  @Override
  public Page<TravelApplyDetailVo> findDetailByConditions(Pageable pageable, TravelApplyPageDto dto) {
    return this.travelApplyVoRepository.findDetailByConditions(pageable, dto);
  }
}
