package com.biz.crm.sfa.admin.web.login.decision;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.mdm.business.user.sdk.service.UserValidityCheckService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.admin.web.login.DefaultAuthenticationDecisionStrategy;
import com.biz.crm.sfa.admin.web.login.form.LoginFormDetails;
import com.bizunited.nebula.security.sdk.login.AuthenticationDecisionStrategy;
import com.bizunited.nebula.security.sdk.login.DecisionTypes;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

import java.nio.charset.StandardCharsets;

/**
 * 典型的账户名+密码方式策略实现
 *
 * @author pengxi
 */
@Slf4j
@Component
public class DefaultAccountAndPasswordStrategy extends DefaultAuthenticationDecisionStrategy implements AuthenticationDecisionStrategy {

  @Autowired
  private UserValidityCheckService userValidityCheckService;

  @Override
  public Integer type() {
    return DecisionTypes.ACCOUNTANDPASSWORD.getCode();
  }

  @Override
  public UserIdentity decide(LoginDetails loginDetails, Integer integer) {
    /*
     * 处理过程如下：
     * 1、首先通过登录账号查询当前用户并检查用户有效性
     * 2、检查登录密码是否正确
     * 3、然后完善登录信息中的用户基本信息
     * 4、最后完善登录信息中的岗位组织等信息
     */
    LoginFormDetails loginUserDetails = (LoginFormDetails) loginDetails;
    log.info("HttpServletRequest account:{}", loginUserDetails.getAccount());
    log.info("HttpServletRequest password:{}", loginUserDetails.getPassword());
    Validate.notBlank(loginUserDetails.getAccount(), "登录账号不能为空！");
    Validate.notBlank(loginUserDetails.getPassword(), "登录密码不能为空！");
    // 1、
    UserVo userVo = this.userValidityCheckService.verificationManageByAccount(loginUserDetails.getAccount());
    Validate.notNull(userVo, "当前系统不存在此账号，请联系管理员！");
    // 2、密码校验过程先按与前端约定的加密方式做解密，然后md5再做校验
    String passwordEncryption = DigestUtils.md5DigestAsHex(loginUserDetails.getPassword().getBytes(StandardCharsets.UTF_8));
    Validate.isTrue(passwordEncryption.equals(userVo.getUserPassword()), "登录密码错误！");
    // 3、
    FacturerUserDetails mdmUser = new FacturerUserDetails();
    mdmUser.setLoginType(DecisionTypes.ACCOUNTANDPASSWORD.getCode());
    super.perfectLoginUserDetails(userVo, mdmUser);
    // 4、
    super.perfectLoginPostAndOrg(mdmUser);
    return mdmUser;
  }

}
