package com.biz.crm.sfa.admin.web.login.decision;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import com.biz.crm.mdm.business.user.sdk.service.UserValidityCheckService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.admin.web.login.DefaultAuthenticationDecisionStrategy;
import com.biz.crm.sfa.admin.web.login.form.LoginFormDetails;
import com.bizunited.nebula.security.sdk.login.AuthenticationDecisionStrategy;
import com.bizunited.nebula.security.sdk.login.DecisionTypes;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 手机号 + 密码方式策略实现
 *
 * @author pengxi
 */
@Slf4j
@Component
public class DefaultPhoneAndSmsCodeStrategy extends DefaultAuthenticationDecisionStrategy implements AuthenticationDecisionStrategy {

  @Autowired
  private UserValidityCheckService userValidityCheckService;

  @Autowired
  private ValiditySmsCodeService validitySmsCodeService;

  @Override
  public Integer type() {
    return DecisionTypes.PHONEANDSMSCODE.getCode();
  }

  @Override
  public UserIdentity decide(LoginDetails loginDetails, Integer integer) {
    /*
     * 处理过程如下：
     * 1、首先通过手机号查询当前用户并检查用户有效性
     * 2、检查当前短信验证码的有效性
     * 3、填充security鉴权必要信息：tenantCode,account,password
     * 4、然后完善登录信息中的用户基本信息
     * 5、最后完善登录信息中的岗位组织等信息
     */
    LoginFormDetails loginUserDetails = (LoginFormDetails) loginDetails;
    log.info("HttpServletRequest phone:{}", loginUserDetails.getPhone());
    log.info("HttpServletRequest smsVerificationCode:{}", loginUserDetails.getSmsVerificationCode());
    Validate.notBlank(loginUserDetails.getPhone(), "登录手机号不能为空！");
    Validate.notBlank(loginUserDetails.getSmsVerificationCode(), "短信验证码不能为空！");
    // 1、
    UserVo userVo = this.userValidityCheckService.verificationManageByPhone(loginUserDetails.getPhone());
    Validate.notNull(userVo, "当前系统不存在此手机号，请联系管理员！");
    // 2、
    Boolean isAvailable = this.validitySmsCodeService.isAvailableVerificationCode(loginUserDetails.getPhone(), loginUserDetails.getSmsVerificationCode());
    Validate.isTrue(isAvailable, "验证码过期或不正确，请重新获取！");
    // 3、4、
    super.perfectLoginFormDetails(userVo, loginUserDetails);
    FacturerUserDetails mdmUser = new FacturerUserDetails();
    mdmUser.setLoginType(DecisionTypes.PHONEANDSMSCODE.getCode());
    super.perfectLoginUserDetails(userVo, mdmUser);
    // 5、
    super.perfectLoginPostAndOrg(mdmUser);
    return mdmUser;
  }

}
