package com.biz.crm.sfa.admin.web.login.decision;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.mdm.business.user.sdk.service.UserValidityCheckService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.admin.web.config.WxAppletConfig;
import com.biz.crm.sfa.admin.web.login.DefaultAuthenticationDecisionStrategy;
import com.biz.crm.sfa.admin.web.login.form.LoginFormDetails;
import com.biz.crm.sfa.admin.web.mobile.vo.OpenIdVo;
import com.bizunited.nebula.security.sdk.login.AuthenticationDecisionStrategy;
import com.bizunited.nebula.security.sdk.login.DecisionTypes;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 小程序登录方式策略实现
 *
 * @author pengxi
 */
@Slf4j
@Component
public class DefaultWxAppletLoginStrategy extends DefaultAuthenticationDecisionStrategy implements AuthenticationDecisionStrategy {

  @Autowired
  private UserValidityCheckService userValidityCheckService;

  @Autowired
  private WxAppletConfig wxAppletConfig;

  @Override
  public Integer type() {
    return DecisionTypes.OTHER.getCode();
  }

  @Override
  public UserIdentity decide(LoginDetails loginDetails, Integer integer) {
    /*
     * 处理过程如下：
     * 1、首先通过openid查询当前用户并检查用户有效性
     * 3、填充security鉴权必要信息：tenantCode,account,password
     * 4、然后完善登录信息中的用户基本信息
     * 5、最后完善登录信息中的岗位组织等信息
     */
    LoginFormDetails loginUserDetails = (LoginFormDetails) loginDetails;
    log.info("HttpServletRequest checkCode:{}", loginUserDetails.getCheckCode());
    Validate.notBlank(loginUserDetails.getCheckCode(), "微信小程序登录凭证不能为空！");
    // 1、
    OpenIdVo openIdVo = this.wxAppletConfig.getAppletOpenId(loginUserDetails.getCheckCode());
    Validate.notNull(openIdVo, "获取openId失败！");
    UserVo userVo = this.userValidityCheckService.verificationManageByOpenid(openIdVo.getOpenid());
    Validate.notNull(userVo, "当前系统不存在此openid，请联系管理员！");
    // 3、4、
    super.perfectLoginFormDetails(userVo, loginUserDetails);
    FacturerUserDetails mdmUser = new FacturerUserDetails();
    mdmUser.setLoginType(DecisionTypes.OTHER.getCode());
    super.perfectLoginUserDetails(userVo, mdmUser);
    // 5、
    super.perfectLoginPostAndOrg(mdmUser);
    return mdmUser;
  }

}
