package com.biz.crm.sfa.admin.web.login.form;

import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import com.bizunited.nebula.security.sdk.loginform.LoginValidateStrategy;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * CRM中，所支持的厂商身份用户登录，所使用的表单信息验证和转换策略</p>
 * <p>
 * TODO 为什么没有使用系统自带的nebula实现的SimpleLoginValidateStrategy，是因为有一个appType字段。
 *
 * @author yinwenjie
 */
@Component
@Primary
public class SimpleLoginValidateStrategy implements LoginValidateStrategy {

  @Override
  public boolean matched(HttpServletRequest request, Integer type) {
    return type >= 1 && type <= 7;
  }

  @Override
  public LoginDetails validateAndTransform(HttpServletRequest request) {
    return new LoginFormDetails(request);
  }
}
