package com.biz.crm.sfa.admin.web.mobile.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.admin.web.mobile.service.CycleVisitPlanLineRouteVoService;
import com.biz.crm.sfa.admin.web.mobile.vo.CycleVisitPlanLineRouteVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 周期性线路组拜访计划(VisitPlan)表相关的http接口
 *
 * @author songjingen
 * @since 2022-05-06 11:15:39
 */
@RestController
@RequestMapping("/v1/mobile/CycleVisitPlanLineRouteVo")
@Slf4j
@Api(tags = "周期性拜访计划:CycleVisitPlanLineRouteVo:周期性线路组拜访计划")
public class CycleVisitPlanLineRouteVoController {
  /**
   * 服务对象
   */
  @Autowired
  private CycleVisitPlanLineRouteVoService visitPlanLineRouteVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<CycleVisitPlanLineRouteVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                  @ApiParam(name = "visitUserName", value = "拜访账号") @RequestParam("visitUserName") String visitUserName) {
    try {
      Page<CycleVisitPlanLineRouteVo> page = this.visitPlanLineRouteVoService.findByConditions(pageable, visitUserName);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
