package com.biz.crm.sfa.admin.web.mobile.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.admin.web.mobile.dto.NearbyClientDto;
import com.biz.crm.sfa.admin.web.mobile.service.NearbyClientVoService;
import com.biz.crm.sfa.admin.web.mobile.vo.NearbyClientVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 附近客户相关的http接口
 *
 * @author songjingen
 * @since 2022-05-06 11:15:39
 */
@RestController
@RequestMapping("/v1/mobile/nearbyClientVo")
@Slf4j
@Api(tags = "附近客户:NearbyClientVo:附近客户")
public class NearbyClientVoController {
  /**
   * 服务对象
   */
  @Autowired
  private NearbyClientVoService nearbyClientVoService;

  /**
   * 通过查询条件查询未合作客户信息
   *
   * @param dto 查询条件
   * @return
   */
  @ApiOperation(value = "通过查询条件查询未合作客户信息")
  @GetMapping("findNoncooperationByConditions")
  public Result<List<NearbyClientVo>> findNoncooperationByConditions(@ApiParam(name = "dto", value = "查询条件") NearbyClientDto dto) {
    try {
      List<NearbyClientVo> nearbyClientVos = this.nearbyClientVoService.findNoncooperationByConditions(dto);
      return Result.ok(nearbyClientVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过查询条件查询已合作客户信息
   *
   * @param dto 查询条件
   * @return
   */
  @ApiOperation(value = "通过查询条件查询已合作客户信息")
  @GetMapping("findCooperationByConditions")
  public Result<List<NearbyClientVo>> findCooperationByConditions(@ApiParam(name = "dto", value = "查询条件") NearbyClientDto dto) {
    try {
      List<NearbyClientVo> nearbyClientVos = this.nearbyClientVoService.findCooperationByConditions(dto);
      return Result.ok(nearbyClientVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
