package com.biz.crm.sfa.admin.web.mobile.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.admin.web.config.WxAppletConfig;
import com.biz.crm.sfa.admin.web.mobile.vo.OpenIdVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 微信相关http接口
 *
 * @author songjingen
 * @since 2022-05-06 11:15:39
 */
@RestController
@RequestMapping("/v1/mobile/openIdVo")
@Slf4j
@Api(tags = "微信相关接口:OpenIdVo:微信相关接口")
public class OpenIdVoController {

  @Autowired
  private WxAppletConfig wxAppletConfig;

  /**
   * 获取openid
   *
   * @param checkCode 登录凭证
   * @return
   */
  @ApiOperation(value = "获取openid")
  @GetMapping("findByCheckCode")
  public Result<OpenIdVo> findByCheckCode(@ApiParam(name = "checkCode", value = "凭证") String checkCode) {
    try {
      if (StringUtils.isBlank(checkCode)) {
        return Result.ok(new OpenIdVo());
      }
      OpenIdVo appletOpenId = this.wxAppletConfig.getAppletOpenId(checkCode);
      return Result.ok(appletOpenId);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
