package com.biz.crm.sfa.admin.web.mobile.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.mobile.dto.ClientDto;
import com.biz.crm.sfa.admin.web.mobile.vo.ClientVo;
import org.springframework.data.domain.Pageable;

/**
 * 客户管理服务类
 *
 * @author songjingen
 */
public interface ClientVoService {

  /**
   * 查询客户列表信息（当前及其下属）
   *
   * @param pageable 分页参数
   * @param dto      分页条件
   * @return
   */
  Page<ClientVo> findByConditions(Pageable pageable, ClientDto dto);

  /**
   * 获取当前用户指定日期未拜访的客户信息列表
   *
   * @param pageable 分页参数
   * @param dto      分页条件
   * @return
   */
  Page<ClientVo> findNotVisitClientByVisitDate(Pageable pageable, ClientDto dto);
}
