package com.biz.crm.sfa.admin.web.mobile.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.gaode.sdk.dto.QueryAroundDto;
import com.biz.crm.common.gaode.sdk.service.GaoDeAroundService;
import com.biz.crm.common.gaode.sdk.vo.GaoDeNearbyVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.sfa.admin.web.mobile.dto.NearbyClientDto;
import com.biz.crm.sfa.admin.web.mobile.service.NearbyClientVoService;
import com.biz.crm.sfa.admin.web.mobile.vo.NearbyClientVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.strange.visit.local.entity.StrangeVisit;
import com.biz.crm.sfa.business.strange.visit.local.service.StrangeVisitService;
import com.biz.crm.sfa.business.strange.visit.sdk.enums.StrangeStatusEnum;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetail;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailService;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 附近终端服务实现类
 *
 * @author songjingen
 */
@Service
public class NearbyClientVoServiceImpl implements NearbyClientVoService {

  @Autowired
  private GaoDeAroundService gaoDeAroundService;

  @Autowired
  private TerminalVoService terminalVoService;

  @Autowired
  private CustomerVoService customerVoService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private StrangeVisitService strangeVisitService;

  @Autowired
  private VisitPlanDetailService visitPlanDetailService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  public List<NearbyClientVo> findNoncooperationByConditions(NearbyClientDto dto) {
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    if (dto == null || StringUtils.isBlank(dto.getLocation())) {
      return new ArrayList<>(0);
    }
    if (dto == null || StringUtils.isBlank(dto.getLocation())) {
      return new ArrayList<>(0);
    }
    //获取高德服务数据
    List<GaoDeNearbyVo> gaoDeNearbyVos = this.getGaoDeNearbyVos(dto);
    //高德数据转换成所需数据集合
    List<NearbyClientVo> nearbyClientVos = this.gaoDeDataConvert(gaoDeNearbyVos);
    //通过高德id查询mdm的终端和经销商数据，并且过滤掉已合作客户
    Set<String> amapIds = nearbyClientVos.stream().map(NearbyClientVo::getClientCode).collect(Collectors.toSet());
    List<TerminalVo> terminalVos = this.terminalVoService.findByAmapIds(amapIds);
    if (!CollectionUtils.isEmpty(terminalVos)) {
      List<String> collect = terminalVos.stream().map(TerminalVo::getAmapId).collect(Collectors.toList());
      nearbyClientVos.stream().filter(nearbyClientVo -> !collect.contains(nearbyClientVo.getClientCode()));
    }
    List<CustomerVo> customerVos = this.customerVoService.findByAmapIds(amapIds);
    if (CollectionUtils.isEmpty(customerVos)) {
      List<String> collect = customerVos.stream().map(CustomerVo::getAmapId).collect(Collectors.toList());
      nearbyClientVos.stream().filter(nearbyClientVo -> !collect.contains(nearbyClientVo.getClientCode()));
    }
    if (CollectionUtils.isEmpty(nearbyClientVos)) {
      return new ArrayList<>(0);
    }
    //查询当前时间是否有陌拜任务
    List<StrangeVisit> strangeVisits = this.strangeVisitService.findByClientCodesAndUserNameAndVisitDate(amapIds, loginDetails.getAccount(), dto.getVisitDate());
    Map<String, StrangeVisit> visitHashMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(strangeVisits)) {
      visitHashMap = strangeVisits.stream().collect(Collectors.toMap(StrangeVisit::getClientCode, o -> o));
    }
    for (NearbyClientVo nearbyClientVo : nearbyClientVos) {
      StrangeVisit strangeVisit = visitHashMap.get(nearbyClientVo.getClientCode());
      if (strangeVisit != null) {
        nearbyClientVo.setStrangeStatus(strangeVisit.getStrangeStatus());
        nearbyClientVo.setId(strangeVisit.getId());
      } else {
        nearbyClientVo.setStrangeStatus(StrangeStatusEnum.NOT_VISIT.getDictCode());
      }
    }
    return nearbyClientVos;
  }

  @Override
  public List<NearbyClientVo> findCooperationByConditions(NearbyClientDto dto) {
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    if (dto == null || StringUtils.isBlank(dto.getLocation())) {
      return new ArrayList<>(0);
    }
    List<NearbyClientVo> nearbyClientVoList = new ArrayList<>();
    //获取高德服务数据
    List<GaoDeNearbyVo> gaoDeNearbyVos = this.getGaoDeNearbyVos(dto);
    //高德数据转换成所需数据集合
    List<NearbyClientVo> nearbyClientVos = this.gaoDeDataConvert(gaoDeNearbyVos);
    if (CollectionUtils.isEmpty(nearbyClientVos)) {
      return new ArrayList<>(0);
    }
    //通过高德id查询mdm的终端和经销商数据
    Set<String> amapIds = nearbyClientVos.stream().map(NearbyClientVo::getClientCode).collect(Collectors.toSet());
    List<TerminalVo> terminalVos = this.terminalVoService.findByAmapIds(amapIds);
    Map<String, TerminalVo> terminalVoMap = new HashMap<>();
    Map<String, CustomerVo> customerVoMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(terminalVos)) {
      terminalVoMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getAmapId, a -> a));
    }
    List<CustomerVo> customerVos = this.customerVoService.findByAmapIds(amapIds);
    if (CollectionUtils.isEmpty(customerVos)) {
      customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getAmapId, a -> a));
    }
    for (NearbyClientVo nearbyClientVo : nearbyClientVos) {
      String clientCode = nearbyClientVo.getClientCode();
      TerminalVo terminalVo = terminalVoMap.get(clientCode);
      if (terminalVo != null) {
        NearbyClientVo clientVo = this.nebulaToolkitService.copyObjectByBlankList(nearbyClientVo, NearbyClientVo.class, HashSet.class, ArrayList.class);
        clientVo.setClientCode(terminalVo.getTerminalCode());
        clientVo.setClientName(terminalVo.getTerminalName());
        clientVo.setClientAddress(terminalVo.getTerminalAddress());
        clientVo.setClientType(ClientTypeEnum.TERMINAL.getDictCode());
        clientVo.setClientSubType(terminalVo.getTerminalType());
        nearbyClientVoList.add(clientVo);
      }
      CustomerVo customerVo = customerVoMap.get(clientCode);
      if (customerVo != null) {
        NearbyClientVo clientVo = this.nebulaToolkitService.copyObjectByBlankList(nearbyClientVo, NearbyClientVo.class, HashSet.class, ArrayList.class);
        clientVo.setClientCode(customerVo.getCustomerCode());
        clientVo.setClientName(customerVo.getCustomerName());
        clientVo.setClientAddress(customerVo.getRegisteredAddress());
        clientVo.setClientType(ClientTypeEnum.DEALER.getDictCode());
        clientVo.setClientSubType(customerVo.getCustomerType());
        nearbyClientVoList.add(clientVo);
      }
    }
    if (CollectionUtils.isEmpty(nearbyClientVoList)) {
      return new ArrayList<>(0);
    }
    //查询当前时间是否有拜访任务
    List<String> clientCodes = nearbyClientVoList.stream().map(NearbyClientVo::getClientCode).collect(Collectors.toList());
    List<VisitPlanDetail> visitPlanDetails = this.visitPlanDetailService.findByClientCodesAndUserNameAndVisitDate(clientCodes, loginDetails.getAccount(), dto.getVisitDate());
    Map<String, VisitPlanDetail> visitHashMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(visitPlanDetails)) {
      visitHashMap = visitPlanDetails.stream().collect(Collectors.toMap(VisitPlanDetail::getClientCode, o -> o));
    }
    for (NearbyClientVo nearbyClientVo : nearbyClientVos) {
      VisitPlanDetail visitPlanDetail = visitHashMap.get(nearbyClientVo.getClientCode());
      if (visitPlanDetail != null) {
        nearbyClientVo.setStrangeStatus(visitPlanDetail.getVisitStatus());
        nearbyClientVo.setId(visitPlanDetail.getId());
      } else {
        nearbyClientVo.setStrangeStatus(VisitStatusEnum.NOT_VISIT.getDictCode());
      }
    }
    return nearbyClientVoList;
  }

  /**
   * 获取高德接口数据
   *
   * @param dto
   * @return
   */
  private List<GaoDeNearbyVo> getGaoDeNearbyVos(NearbyClientDto dto) {
//调用高德api查询数据
    QueryAroundDto queryAroundDto = new QueryAroundDto();
    queryAroundDto.setLocation(dto.getLocation())
        .setPage(dto.getPage() == null ? "20" : String.valueOf(dto.getPage()))
        .setOffset(dto.getSize() == null ? "20" : String.valueOf(dto.getSize()))
        .setRadius(null)
        .setKeywords(null)
        .setRadius(null);
    if (StringUtils.isNotBlank(dto.getClientName())) {
      queryAroundDto.setKeywords(dto.getClientName());
    }
    Page<GaoDeNearbyVo> byConditions = this.gaoDeAroundService.findByConditions(queryAroundDto);
    List<GaoDeNearbyVo> records = byConditions.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return new ArrayList<>(0);
    }
    return records;
  }

  /**
   * 高得地图数据转换
   */
  public List<NearbyClientVo> gaoDeDataConvert(List<GaoDeNearbyVo> gaoDeData) {
    if (CollectionUtils.isEmpty(gaoDeData)) {
      return Lists.newArrayList();
    }
    List<NearbyClientVo> respList = gaoDeData.stream().map(m -> {
      NearbyClientVo o = new NearbyClientVo();
      o.setClientCode(m.getId());
      o.setLongitude(new BigDecimal(m.getLongitude()));
      o.setLatitude(new BigDecimal(m.getLatitude()));
      o.setClientAddress(m.getAddress());
      o.setClientPhone(m.getTel());
      o.setClientName(m.getName());
      o.setDistance(new BigDecimal(m.getDistance()).divide(new BigDecimal("1000"), 3, RoundingMode.HALF_UP));
      o.setClientAddress(m.getAddress());
      return o;
    }).collect(Collectors.toList());
    //todo 配置按钮
    return respList;
  }
}
