package com.biz.crm.sfa.admin.web.mobile.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 附近客户信息vo
 *
 * @author songjingen
 */
@Data
@ApiModel(value = "附近客户信息vo")
public class NearbyClientVo implements Serializable {
  private static final long serialVersionUID = -1592215361922098633L;
  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;
  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;
  /**
   * 客户手机号
   */
  @ApiModelProperty("客户手机号")
  private String clientPhone;
  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;
  /**
   * 客户细类
   */
  @ApiModelProperty("客户细类")
  private String clientSubType;
  /**
   * 距离(公里)
   */
  @ApiModelProperty("距离(公里)")
  private BigDecimal distance;
  /**
   * 距离单位(公里)
   */
  @ApiModelProperty("距离单位(公里)")
  private String unit = "Km";
  /**
   * 网点地址
   */
  @ApiModelProperty("网点地址")
  private String clientAddress;
  /**
   * 网点经度
   */
  @ApiModelProperty("网点经度")
  private BigDecimal longitude;

  /**
   * 网点纬度
   */
  @ApiModelProperty("网点纬度")
  private BigDecimal latitude;

  /**
   * 陌拜状态
   */
  @ApiModelProperty("陌拜状态")
  private String strangeStatus;

  /**
   * id
   */
  @ApiModelProperty("id")
  private String id;

}
