package com.biz.crm.sfa.admin.web.report.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.admin.web.report.dto.AttendanceRecordDetailPageDto;
import com.biz.crm.sfa.admin.web.report.service.AttendanceRecordDetailVoService;
import com.biz.crm.sfa.admin.web.report.vo.AttendanceRecordDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 考勤记录报表信息
 * @author: rentao
 * @date: 2022/7/5 14:36
 */
@Slf4j
@RestController
@RequestMapping("/v1/attendance/attendanceRecordDetail")
@Api(tags = "考勤记录: AttendanceRecord: 考勤记录报表信息")
public class AttendanceRecordDetailVoController {

  @Autowired private AttendanceRecordDetailVoService attendanceRecordDetailVoService;
  /**
   * 考勤明细报表分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 考勤规则分页数据
   */
  @ApiOperation(value = "后台-考勤明细报表")
  @GetMapping("/findByConditions")
  public Result<Page<AttendanceRecordDetailVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      @ApiParam(name = "AttendanceRecordDetailPageDto", value = "分页Dto") AttendanceRecordDetailPageDto dto) {
    try {
      return Result.ok(this.attendanceRecordDetailVoService.findDetailByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
