package com.biz.crm.sfa.admin.web.report.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.admin.web.report.dto.AttendanceRecordMonthPageDto;
import com.biz.crm.sfa.admin.web.report.service.AttendanceRecordMonthVoService;
import com.biz.crm.sfa.admin.web.report.vo.AttendanceRecordMonthVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 月度考勤报表
 * @author: rentao
 * @date: 2022/7/4 15:27
 */
@Slf4j
@RestController
@RequestMapping("/v1/attendance/attendanceRecordMonth")
@Api(tags = "月度考勤报表: AttendanceHistoryVo: 月度考勤报表")
public class AttendanceRecordMonthVoController {

  @Autowired private AttendanceRecordMonthVoService attendanceHistoryVoService;

  /**
   * 移动端-考勤历史分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceHistoryVo> 考勤历史分页信息
   */
  @ApiOperation(value = "后台-月度考勤报表分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<AttendanceRecordMonthVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      @ApiParam(name = "AttendanceRecordMonthPageDto", value = "分页Dto") AttendanceRecordMonthPageDto dto) {
    try {
      return Result.ok(this.attendanceHistoryVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
