package com.biz.crm.sfa.admin.web.report.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.admin.web.report.dto.HelpDefensePlanDetailPageDto;
import com.biz.crm.sfa.admin.web.report.service.HelpDefensePlanDetailReportVoService;
import com.biz.crm.sfa.admin.web.report.vo.HelpDefensePlanDetailReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 协访明细报表
 */
@Slf4j
@RestController
@RequestMapping("/v1/helpDefenseReportDetailVo/helpDefenseReportDetailVo")
@Api(tags = "协访明细报表: HelpDefensePlanDetailVo: 协访明细报表")
public class HelpDefensePlanReportVoController {

  @Autowired
  private HelpDefensePlanDetailReportVoService helpDefensePlanDetailReportVoService;


  /**
   * 协访明细报表
   * @param pageable 分页信息
   * @param dto 查询参数
   * @return 协访明细报表
   */
  @ApiOperation(value = "协访明细报表")
  @GetMapping("/findByConditions")
  public Result<Page<HelpDefensePlanDetailReportVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                      @ApiParam(name = "WorkOverTimePageDto", value = "分页Dto") HelpDefensePlanDetailPageDto dto) {
    try {
      return Result.ok(this.helpDefensePlanDetailReportVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
