package com.biz.crm.sfa.admin.web.report.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 月度考勤分页Dto
 * @author: rentao
 * @date: 2022/7/4 15:32
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceRecordMonthPageDto", description = "月度考勤分页Dto")
public class AttendanceRecordMonthPageDto extends TenantDto {

  @ApiModelProperty("账号集合")
  private Set<String> userNames;

  @ApiModelProperty("人员姓名")
  private String userRealName;

  @ApiModelProperty("账号")
  private String userName;

  @ApiModelProperty("职位编码")
  private String postCode;

  @ApiModelProperty("职位名称")
  private String postName;

  @ApiModelProperty("组织编码")
  private String orgCode;

  @ApiModelProperty("组织名称")
  private String orgName;

  @ApiModelProperty("考勤日期(yyyy)")
  private String ruleYear;

  @ApiModelProperty("考勤日期(MM)")
  private String ruleMonth;

}
