package com.biz.crm.sfa.admin.web.report.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 协访明细报表分页dto
 * @author jerry7
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "WorkOverTimePageDto", description = "协访明细报表分页Dto")
public class HelpDefensePlanDetailPageDto extends TenantDto {

  /**
   * 提交开始时间
   */
  @ApiModelProperty(value = "提交开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date submitStartTime;
  /**
   * 提交结束时间
   */
  @ApiModelProperty(value = "提交结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date submitEndTime;

  /**
   * 协访状态
   */
  @ApiModelProperty("协访状态")
  private String helpStatus;
  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;
  /**
   * 被协访人员姓名
   */
  @ApiModelProperty("被协访人员姓名")
  private String coverHelpRealName;
  /**
   * 协访人员姓名
   */
  @ApiModelProperty("协访人员姓名")
  private String helpRealName;
  /**
   * 协访人员职位名称
   */
  @ApiModelProperty("协访人员职位名称")
  private String helpPosName;



}
